*! version 5.0
* 13 August 2018
* NIDS 
* Merging Individual questionnaires to the Household roster, Household Questionnaire, Individual derived and Household derived
* to create a Cross-sectional dataset.

* Will run on all waves

* Please Note: The final dataset will include Non-residents and deceased respondents.

*===========================================================================================================================================
* GLOBALS FOR DATA FILES AND VERSION SUFFIXES

global DataIN "C:\Users\Admin\Desktop\Data"
global DataOUT "C:\Users\Admin\Desktop\Data"
global VersionIN "W5_Anon_V1.0.0"
global VersionOUT "merged"

global temp "C:\Users\Admin\Desktop\Data"		// tempfile to hold all the working datasets, all working datasets will
												// be deleted from this folder at the completion of the do file.
																		
version 15.1									// version of Stata being used, this is needed for the rename command.

*===========================================================================================================================================

* OPENING THE INDIVIDUAL FILES, REMOVING INDIVIDUAL SPECIFIC PREFIX, REPLACING WITH WAVE SPECIFIC PREFIX AND APPENDING INDIVIDUAL DATA TOGETHER

* ADULT

use "$DataIN\Adult_$VersionIN.dta", clear					// opening the dataset
	
rename w#_a* w#*											// replacing the current prefix with a wave specific prefix
gen dataset = "Adult"										// generating a variable to indicate the source dataset

save "$temp\adult.dta", replace								// saving the modified data as a temp file
	
* PROXY

use "$DataIN\Proxy_$VersionIN.dta", clear					// opening the dataset

rename w#_p* w#*											// replacing the current prefix with a wave specific prefix
gen dataset = "Proxy"										// generating a variable to indicate the source dataset

save "$temp\proxy.dta", replace								// saving the modified data as a temp file

* CHILD

use "$DataIN\Child_$VersionIN.dta", clear					// opening the dataset

rename w#_c* w#*											// replacing the current prefix with a wave specific prefix
gen dataset = "Child"										// generating a variable to indicate the source dataset

append using "$temp\adult.dta"								// appending the modified adult temp file to the adjusted child file
append using "$temp\proxy.dta"								// appending the modified proxy temp file to the adjusted child file

order dataset, last											// moving the variable "dataset" to the end of the dataset

save "$temp\indi.dta", replace								// saving the modified data as a temp file

*-------------------------------------------------------------------------------------------------------------------------------------------

* OPENING THE HOUSEHOLD ROSTER AND MERGING THE INDIVIDUAL FILE CREATED ABOVE INTO IT.

use "$DataIN\HouseholdRoster_$VersionIN.dta", clear			// opening the household roster

merge 1:1 pid *hhid using "$temp\indi.dta"					// performing a 1 to 1 merge on pid and hhid, between the individuals and the roster 
drop _merge

*-------------------------------------------------------------------------------------------------------------------------------------------

* MERGING IN THE HOUSEHOLD QUESTIONNAIRE.

merge m:1 *hhid using "$DataIN\HHQuestionnaire_$VersionIN.dta"	// performing a many to one merge on hhid, between the individuals and the household questionnaire
drop _merge

*-------------------------------------------------------------------------------------------------------------------------------------------

* MERGING IN THE INDIVIDUAL DERIVED DATASET. 

merge 1:1 pid *hhid using "$DataIN\indderived_$VersionIN.dta"	// performing a one to one merge on pid hhid to the individual derived dataset
drop _merge

*-------------------------------------------------------------------------------------------------------------------------------------------

* MERGING IN THE HOUSEHOLD DERIVED DATASET.

merge m:1 *hhid using "$DataIN\hhderived_$VersionIN.dta"		// performing a many to one merge on hhid, between the individuals and the household derived dataset
drop _merge

save "$DataOUT\Crossection_$VersionOUT.dta", replace			// saving out the resulting dataset, the defined path, as per globals

*-------------------------------------------------------------------------------------------------------------------------------------------

* ERASING THE TEMP FILES

erase "$temp\adult.dta"
erase "$temp\proxy.dta"
erase "$temp\indi.dta"

*end of do file
*--------------------------------------------------------------------------------------------------------------------------------------------



